// IMPORT

const {ipcRenderer} = require('electron')
let configPanelStatus = 0;
let configPanelChannelStatus = 0;

// MAIN DATA COMMUNICATION

ipcRenderer.on('data-communication', function (event,json) {
    var data = JSON.parse(json)

    data.forEach(function(data){
        raw_level = data['level']
        level_100 = Math.trunc(raw_level / 127 * 100);
        $('.channel' + data['id'] + '-fader-volume').width(level_100)
		
		if(parseInt(level_100) > 1) {
		   $('.' + data['id'] + '-status').removeClass("btn-danger");
		   $('.' + data['id'] + '-status').addClass("btn-success");
		   $('.' + data['id'] + '-status').html('ON');
		} else {
		   $('.' + data['id'] + '-status').removeClass("btn-success");
		   $('.' + data['id'] + '-status').addClass("btn-danger");
		   $('.' + data['id'] + '-status').html('OFF');
		}
		
    });
});

// EXTERNAL LINK

$('.external-link').on('click', 'a', (event) => {
  event.preventDefault();
  require("electron").shell.openExternal(event.target.href);
});

// CONFIG PANEL

$('.button-config').click(function(event) {
  event.preventDefault();
  var channelConfigStatus = $(this).data("configureid")
  
  $('.option-row').data('currentchannel', channelConfigStatus);
  
  $('.option-row').removeClass("channel-or-1");
  $('.option-row').removeClass("channel-or-2");
  $('.option-row').removeClass("channel-or-3");
  $('.option-row').removeClass("channel-or-4");
  $('.option-row').removeClass("channel-or-5");
  $('.option-row').removeClass("channel-or-6");

  $('.option-row').addClass("channel-or-" + channelConfigStatus);

  ipcRenderer.send('get-value-and-send-back', 'script-off-channel-' + channelConfigStatus);
  ipcRenderer.send('get-value-and-send-back', 'script-on-channel-' + channelConfigStatus);
  ipcRenderer.send('get-value-and-send-back', 'wemo-device-ip-channel-' + channelConfigStatus);

  if(configPanelStatus == 1 && configPanelChannelStatus != channelConfigStatus) {
	  configPanelStatus = 0;
  }
  
  if(configPanelStatus == 0) {
		ipcRenderer.send('resize-full');
		$('.option-row').show();
		
        $('.tab-content-config').hide();
		$('.tab-content-config').fadeIn('fast');

		$('.top-config-title').html("Channel " + channelConfigStatus);
	    configPanelStatus = 1;
        configPanelChannelStatus = channelConfigStatus;
  } else {
		ipcRenderer.send('resize-half');
		$('.option-row').hide();

        $('.tab-content-config').hide();
		$('.tab-content-config').fadeIn('fast');
		
		$('.top-config-title').html("Channel " + channelConfigStatus);
	    configPanelStatus = 0;
		configPanelChannelStatus = channelConfigStatus;
  }
  

});

// SCRIPTS RECEIVING PART

ipcRenderer.on('getkey-script-off-channel-1', function (event,data) { $('.update-off-script-input').val(data); });
ipcRenderer.on('getkey-script-off-channel-2', function (event,data) { $('.update-off-script-input').val(data); });
ipcRenderer.on('getkey-script-off-channel-3', function (event,data) { $('.update-off-script-input').val(data); });
ipcRenderer.on('getkey-script-off-channel-4', function (event,data) { $('.update-off-script-input').val(data); });
ipcRenderer.on('getkey-script-off-channel-5', function (event,data) { $('.update-off-script-input').val(data); });
ipcRenderer.on('getkey-script-off-channel-6', function (event,data) { $('.update-off-script-input').val(data); });

ipcRenderer.on('getkey-script-on-channel-1', function (event,data) { $('.update-on-script-input').val(data); });
ipcRenderer.on('getkey-script-on-channel-2', function (event,data) { $('.update-on-script-input').val(data); });
ipcRenderer.on('getkey-script-on-channel-3', function (event,data) { $('.update-on-script-input').val(data); });
ipcRenderer.on('getkey-script-on-channel-4', function (event,data) { $('.update-on-script-input').val(data); });
ipcRenderer.on('getkey-script-on-channel-5', function (event,data) { $('.update-on-script-input').val(data); });
ipcRenderer.on('getkey-script-on-channel-6', function (event,data) { $('.update-on-script-input').val(data); });


// SCRIPTS SENDING PART

$('.update-off-script-button').click(function(event) {
	let input_of = $('.update-off-script-input').val();
	let channel_chosen = $('.option-row').data("currentchannel");
	let channel_saved_data_off = 'script-off-channel-' + channel_chosen;
	ipcRenderer.send('save-to-config', channel_saved_data_off, input_of);
	ipcRenderer.send('toast', 'Updated!');
});

$('.update-on-script-button').click(function(event) {
	let input_of = $('.update-on-script-input').val();
	let channel_chosen = $('.option-row').data("currentchannel");
	let channel_saved_data_on = 'script-on-channel-' + channel_chosen;
	ipcRenderer.send('save-to-config', channel_saved_data_on, input_of);
	ipcRenderer.send('toast', 'Updated!');
});

// SCRIPTS RECEIVING PART

ipcRenderer.on('getkey-wemo-device-ip-channel-1', function (event,data) { $('.update-wemo-device-ip-input').val(data); });
ipcRenderer.on('getkey-wemo-device-ip-channel-2', function (event,data) { $('.update-wemo-device-ip-input').val(data); });
ipcRenderer.on('getkey-wemo-device-ip-channel-3', function (event,data) { $('.update-wemo-device-ip-input').val(data); });
ipcRenderer.on('getkey-wemo-device-ip-channel-4', function (event,data) { $('.update-wemo-device-ip-input').val(data); });
ipcRenderer.on('getkey-wemo-device-ip-channel-5', function (event,data) { $('.update-wemo-device-ip-input').val(data); });
ipcRenderer.on('getkey-wemo-device-ip-channel-6', function (event,data) { $('.update-wemo-device-ip-input').val(data); });

// WEMO SENDING PART

$('.update-wemo-device-ip-button').click(function(event) {
	let input_of = $('.update-wemo-device-ip-input').val();
	let channel_chosen = $('.option-row').data("currentchannel");
	let channel_saved_data = 'wemo-device-ip-channel-' + channel_chosen;
	ipcRenderer.send('save-to-config', channel_saved_data, input_of);
	ipcRenderer.send('toast', 'Updated!');
});